//Caption:Hamming Encoding
//H(7,4)
//Code Word Length = 7, Message Word length = 4, Parity bits =3
//clear;
close;
clc;
//Getting Message Word
m3 = input('Enter the 1 bit(MSb) of message word');
m2 = input('Enter the 2 bit of message word');
m1 = input('Enter the 3 bit of message word');
m0 = input('Enter the 4 bit(LSb) of message word');
//Generating Parity bits
for i = 1:(2^4)
  b2(i) = xor(m0(i),xor(m3(i),m1(i)));
  b1(i) = xor(m1(i),xor(m2(i),m3(i)));
  b0(i) = xor(m0(i),xor(m1(i),m2(i)));
  m(i,:) = [m3(i) m2(i) m1(i) m0(i)];
  b(i,:) = [b2(i) b1(i) b0(i)];
end
C = [b m];
disp('___________________________________________________________')
for i = 1:2^4
  disp(i)
  disp(m(i,:),'Message Word')
  disp(b(i,:),'Parity Bits')
  disp(C(i,:),'CodeWord')
  disp("   ");
  disp("   ");
end
disp('___________________________________________________________')
//Input
//Enter the 1 bit(MSb) of message word [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1];
//Enter the 2 bit of message word [0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1];
//Enter the 3 bit of message word [0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1];
//Enter the 4 bit(LSb) of message word [0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1];
//Output Result
//Message Word   
//     0.    0.    0.    0.  
// Parity Bits   
//     0.    0.    0.  
// CodeWord   
//     0.    0.    0.    0.    0.    0.    0.  
// // 2.  
//  Message Word   
//     0.    0.    0.    1.  
//  Parity Bits   
//     1.    0.    1.  
//  CodeWord   
//     1.    0.    1.    0.    0.    0.    1.  
// //     3.  
//  Message Word   
//     0.    0.    1.    0.  
//  Parity Bits   
//     1.    1.    1.  
//  CodeWord   
//     1.    1.    1.    0.    0.    1.    0.  
// //  4.  
//  Message Word   
//     0.    0.    1.    1.  
//  Parity Bits   
//     0.    1.    0.  
//  CodeWord   
//     0.    1.    0.    0.    0.    1.    1.  
// //    5.  
//  Message Word   
//     0.    1.    0.    0.  
//  Parity Bits   
//     0.    1.    1.  
//  CodeWord   
//     0.    1.    1.    0.    1.    0.    0.  
// //  6.   
// Message Word   
//     0.    1.    0.    1.  
// Parity Bits   
//     1.    1.    0.  
// CodeWord   
//     1.    1.    0.    0.    1.    0.    1.  
// //  7.  
//  Message Word   
//     0.    1.    1.    0.  
//  Parity Bits   
//    1.    0.    0.  
//  CodeWord   
//     1.    0.    0.    0.    1.    1.    0.  
// //   8.  
//  Message Word   
//     0.    1.    1.    1.  
//  Parity Bits   
//     0.    0.    1.  
//  CodeWord   
//     0.    0.    1.    0.    1.    1.    1.  
// //    9.  
//  Message Word   
//     1.    0.    0.    0.  
//  Parity Bits   
//     1.    1.    0.  
//  CodeWord   
//     1.    1.    0.    1.    0.    0.    0.  
// //    10.  
//  Message Word   
//     1.    0.    0.    1.  
//  Parity Bits   
//     0.    1.    1.  
//  CodeWord   
//     0.    1.    1.    1.    0.    0.    1.  
// //    11.  
//  Message Word   
//     1.    0.    1.    0.  
//  Parity Bits   
//     0.    0.    1.  
//  CodeWord   
//     0.    0.    1.    1.    0.    1.    0.  
// //    12.  
//  Message Word   
//     1.    0.    1.    1.  
//  Parity Bits   
//     1.    0.    0.  
//  CodeWord   
//     1.    0.    0.    1.    0.    1.    1.  
// //    13.  
//  Message Word   
//     1.    1.    0.    0.  
//  Parity Bits   
//     1.    0.    1.  
//  CodeWord   
//     1.    0.    1.    1.    1.    0.    0.  
// //     14.  
//  Message Word   
//     1.    1.    0.    1.  
//  Parity Bits   
//     0.    0.    0.  
//  CodeWord   
//     0.    0.    0.    1.    1.    0.    1.  
// //   15.  
//  Message Word   
//     1.    1.    1.    0.  
//  Parity Bits   
//     0.    1.    0.  
//  CodeWord   
//     0.    1.    0.    1.    1.    1.    0.  
// //    16.  
//  Message Word   
//     1.    1.    1.    1.  
//  Parity Bits   
//     1.    1.    1.  
//  CodeWord   
//     1.    1.    1.    1.    1.    1.    1.